DESCRIPTION = "Files to init things for read-only file system"

FILESEXTRAPATHS_prepend := "${THISDIR}/files:"

SRC_URI += " \
            file://50-panic_tch.conf \
            file://50-disable-coredump.conf \
           "

# Enable Core Dump control at user space.
EXTRA_OECONF_remove = " --disable-coredump"

VOLATILE_DIRS = "\
    /var/volatile/lib /var/lib\n\
    /var/volatile/dibbler /opt/dibbler\n\
    /tmp/dibbler /etc/dibbler\n\
    /var/volatile/media /media\n\
    /var/volatile/spoolcron /var/spool/cron\n\
    /var/volatile/www /www\n\
    /var/volatile/xupnp /etc/xupnp\n\
    /var/volatile/rdklogs /rdklogs size=10m\n\
    /var/volatile/minidumps /minidumps size=2m\n\
"

VOLATILE_FILES = "\
    /etc/fan_config\n\
    /etc/log4crc\n\
    /etc/ti_syslog.conf\n\
    /etc/zebra.conf\n\
    /etc/ssmtp.conf\n\
    /etc/resolv.conf\n\
    /etc/asound.conf\n\
    /etc/resolv.dnsmasq\n\
    /etc/hosts\n\
    /etc/hostname\n\
    /etc/dhcp_static_hosts\n\
    /etc/snmp/snmpd.conf\n\
    /etc/systemd/timesyncd.conf\n\
    /etc/udhcpc.vendor_specific\n\
"

do_install_append() {
    install -m 644 ${WORKDIR}/50-panic_tch.conf ${D}${sysconfdir}/sysctl.d
    sed -i -e 's/^#DefaultRestartSec=.*$/DefaultRestartSec=10s/g' ${D}${sysconfdir}/systemd/system.conf
    sed -i -e 's/^#DefaultStartLimitInterval=.*$/DefaultStartLimitInterval=10s/g' ${D}${sysconfdir}/systemd/system.conf

    # Disable coredump since minidump is preferred
    install -m 755 ${WORKDIR}/50-disable-coredump.conf ${D}${sysconfdir}/sysctl.d/

    # Create mount points in case od read-only
    # file system.
	while read spec mountpoint; do
        if [ -z "$spec" ]; then
            continue
        fi

        echo "L+ $spec - - - - ../var/volatile$spec" >> ${D}/usr/lib/tmpfiles.d/etc.conf
    done <<END
${@d.getVar('VOLATILE_FILES', True).replace("\\n", "\n")}
END

    while read spec mountpoint options; do
        if [ -z "$spec" ]; then
            continue
        fi

        if [[ "$mountpoint" != *.* ]];then
            install -d 0755 ${D}"$mountpoint"
        fi
    done <<END
${@d.getVar('VOLATILE_DIRS', True).replace("\\n", "\n")}
END
}

# Enable coredump config in rootfs
CONFFILES_${PN} += "${sysconfdir}/systemd/coredump.conf"

# Coredump list and backtrace on missed minidumps.
FILES_${PN} += "${bindir}/coredumpctl"
FILES_${PN} += "/opt /rdklogs /www /media /minidumps /etc/dibbler /etc/xupnp"
